/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef _DTVRECDD_MEMMAP_H_
#define _DTVRECDD_MEMMAP_H_

#include <linux/autoconf.h>
#include <dtvrecdd/memtrans.h>


#define DEV_EXMEM                       "/dev/exmem"

#if 1
#include <scc/ucd_memmap.h>
#else
#define DDR_CH1_OFFSET                  0x00000000
#define DDR_CH1_SIZE                    0x10000000

#define AMINT_START_OFFSET              0x00000000
#define AMINT_SIZE                      0x00002000

#define UCODE_START_OFFSET              0x00000000
#define UCODE_SIZE                      0x0030F000

#define IPR_START_OFFSET                0x0C23D000
#define IPR_SIZE                        0x018F3000

#define OD_START_OFFSET                 0x0DB30000
#define OD_SIZE                         0

#define ATVD_START_OFFSET               0x0DB30000
#define ATVD_SIZE                       0x00399999

#define RTSC_START_OFFSET               0x09B00000
#define RTSC_SIZE                       0x01E00000
#define RTSC_MARGIN                     0

#define SECURE_START_OFFSET             0x06470000
#define SECURE_SIZE                     0x00100000

#define RECS_START_OFFSET               0x0DECA000
#define RECS_SIZE                       0x00260000

#define GFX0_START_OFFSET               0x0E12A000
#define GFX0_SIZE                       0x026DE000


#define VPES0_START_OFFSET GFX0_START_OFFSET+GFX0_SIZE
#define VPES0_SIZE 0x8000
#define APES0_START_OFFSET VPES0_START_OFFSET+VPES0_SIZE
#define APES0_SIZE 0x14000

#define VPES1_START_OFFSET APES0_START_OFFSET+APES0_SIZE
#define VPES1_SIZE 0x8000
#define APES1_START_OFFSET VPES1_START_OFFSET+VPES1_SIZE
#define APES1_SIZE 0x14000



#define DDI_GPU_START_OFFSET            0x10708000
#define DDI_GPU_SIZE                    0x03200000

#define CPU0_START_OFFSET              (CONFIG_KERNEL_RAM_BASE_ADDRESS - 0x80000000)
#define CPU0_SIZE                      (0x20000000-CPU0_START_OFFSET)

#define DECENC1_START_OFFSET            0x02800000
#define DECENC1_SIZE                    0x02600000

#if 0   
# define DDR_CACHE_P_OFFSET              0x00000000 
# define DDR_CACHE_V_OFFSET              0x00000000
# define DDR_CACHE_SIZE                  0x00000000
#endif

#define DDR_UNCACHE_P_OFFSET            0xa0000000 
#define DDR_UNCACHE_V_OFFSET            0x40000000
#define DDR_UNCACHE_SIZE                0x20000000

#if 0   
# define PERI_IO_P_OFFSET                0x40000000 
# define PERI_IO_V_OFFSET                0x40000000
# define PERI_IO_SIZE                    0x10000000
#endif

#define CI_IO_P_OFFSET                  0x49000000 
#define CI_IO_V_OFFSET                  0x70000000
#define CI_IO_SIZE                      0x00001000

#define SOC_IO_P_OFFSET                 0x50000000 
#define SOC_IO_V_OFFSET                 0x70000000
#define SOC_IO_SIZE                     0x10000000

#ifndef CONFIG_ZONE_NORMAL_ADDRESS
#define CONFIG_ZONE_NORMAL_ADDRESS 0x9b000000
#endif

#define DMA_CACHE_P_OFFSET              (0x80000000+CPU0_START_OFFSET) 
#define DMA_CACHE_V_OFFSET              (0x10000000+CPU0_START_OFFSET)
#define DMA_CACHE_SIZE                  (CONFIG_ZONE_NORMAL_ADDRESS-CONFIG_KERNEL_RAM_BASE_ADDRESS)
#define DMA_UNCACHE_P_OFFSET            (0xa0000000+CPU0_START_OFFSET) 
#define DMA_UNCACHE_V_OFFSET            (0x50000000+CPU0_START_OFFSET)
#define DMA_UNCACHE_SIZE                (CONFIG_ZONE_NORMAL_ADDRESS-CONFIG_KERNEL_RAM_BASE_ADDRESS)
#endif

#endif                          
